<?php
/*--------------------------------------------------------------------------------------------------
    Repository.php 2020-3-19
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository;


use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeModifierIdentifier;
use Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository\DTO\AttributeInfo;
use Gambio\Shop\Attributes\SellingUnitQuantitiy\Database\Repository\Reader\ReaderInterface;
use Gambio\Shop\Attributes\SellingUnitQuantitiy\ValueObjects\AttributeQuantity;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;
use ProductDataInterface;

class Repository implements RepositoryInterface
{
    /**
     * @var ReaderInterface
     */
    protected $reader;

    /**
     * Repository constructor.
     * @param ReaderInterface $reader
     */
    public function __construct(ReaderInterface $reader)
    {
        $this->reader = $reader;
    }

    /**
     * @inheritDoc
     */
    public function getQuantity(
        ProductId $productId,
        AttributeModifierIdentifier $modifierId,
        ProductDataInterface $product
    ): ?ModifierQuantityInterface {

        /** @var AttributeInfo $dto */
        $dto = $this->reader->getQuantity($productId->value(), $modifierId->value());
        if ($dto) {
            return new AttributeQuantity($dto->value(), $product->measureUnit(), $modifierId);
        }
        return null;
    }
}